<?php
/* This program is licensed under the GNU General Public License, version 2,
 * a copy of which is included with this program.
 *
 * (c) 2003 jan gerber <j@thing.net>
 *
 * rss/rdf parser for v2v
 *
 * version 0.5
 *
 */


$insideitem = false;
$tag = $title = $link = $v2vlink = "";
$v2v = null;

$item_template= implode("", file ('templates/item.template'));

// make links active just an extra feature
function parsed($string) {
  $string = ereg_replace("\n", "<br>\n", $string);
  $string = ereg_replace("[[:alpha:]]+://[^<>[:space:]]+[[:alnum:]/]","<a href=\"\\0\" target=\"_blank\">\\0</a>", $string);
  $string = eregi_replace("([_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)+)","<A HREF=\"mailto:\\1\">\\1</A>", $string);
  return $string;
}


function startElement($parser, $name, $attrs) {
  global $insideitem, $tag;
  if ($insideitem) {
    $tag = $name;
  } elseif ($name == "ITEM") {
    $insideitem = true;
  }
}

function endElement($parser, $name) {
  global $insideitem, $tag, $title, $date, $link, $v2v, $item_template;
  $item=$item_template;
  
  if($name=='V2V:LINK') {
   	$v2v['v2vlink'] .= "<td><a href=\"". $v2v['v2vlink_tmp'] ."\">";
	 	if(stristr($v2v['v2vlink_tmp'],'ed2k')) {
	  					$v2v['v2vlink'] .= "ed2k";
	  	}
				elseif(stristr($v2v['v2vlink_tmp'],'magnet')) {
		  				$v2v['v2vlink'] .= "magnet";
	  				}
					elseif(stristr($v2v['v2vlink_tmp'],'torrent')) {
	  					$v2v['v2vlink'] .= "torrent";
	  				}
					else 
	  					$v2v['v2vlink'] .= $data;
				
			$v2v['v2vlink'] .= "</a><br>\n";
			$v2v['v2vlink_tmp']='';
  }
  elseif ($name == "ITEM") {
    $show=$_GET['sha1'];
    if(!$show || stristr($v2v['v2vlink'],$show) ) {
      	//title
      	if($link) {
		$title= "<a href=\"". trim($link) ."\">". stripslashes(htmlspecialchars(trim($title))) ."</a>";
    }
    elseif(!$show) {
		$sha1 = $v2v['v2vlink'];
		$sha1 = ereg_replace(".*sha1:(................................).*","\\1",trim(urldecode($v2v['v2vlink'])));
		#$link=$_SERVER['REQUEST_URI'] . "?sha1=$sha1";
		$link="http://v2v.cc/link?$sha1";
		$title="<a href=\"". trim($link) ."\">". stripslashes(htmlspecialchars(trim($title))) ."</a>";
    }
    else {
		$title=stripslashes(htmlspecialchars(trim($title)));
    }
    $item = eregi_replace("_title_", $title , $item);
      
    // subtitle
    $item = eregi_replace("_subtitle_", stripslashes(htmlspecialchars(trim($v2v['subtitle']))), $item );
      
    // creator
    if($v2v['videopage']) {
		$item = eregi_replace("_creator_", '<a href="' . $v2v['videopage'] . '">' . stripslashes($v2v['creator']) . '</a>', $item);
    }
    else {
		$item = eregi_replace("_creator_", stripslashes($v2v['creator']), $item);
    }
      
    // description 
    $item = eregi_replace("_desc_", stripslashes($v2v['description']), $item);
    $item = eregi_replace("_duration_", stripslashes($v2v['duration']), $item);
    $item = eregi_replace("_date_", stripslashes($date), $item);
    $item = eregi_replace("_size_", stripslashes($v2v['size']), $item);
    $item = eregi_replace("_lang_", stripslashes($v2v['language']), $item);
    if(!trim($v2v['sublanguage'])) {
		$v2v['sublanguage']='none';
    }
    $item = eregi_replace("_sublang_", stripslashes($v2v['sublanguage']), $item);	  	 
    $item = eregi_replace("_v2vlinks_", stripslashes($v2v['v2vlink']), $item);

    //output the formated item
    echo "$item";
    }
    $title = $date = $link = $v2vlink= "";
    $v2v = null;
    $insideitem = false;
  }
}

// format data for the known elements
function characterData($parser, $data) {
  global $insideitem, $tag, $title, $description, $link,$date,$v2v;
  if ($insideitem) {
    switch ($tag) {
    case "LINK":
        if(trim($data))
	  $link = $data;
	break;
    case "TITLE":
      $title .= $data;
      break;
    case "V2V:LINK":
      if(trim($data)) {
	  $v2v['v2vlink_tmp'] .= $data;
			}
      break;
    case "DC:LANGUAGE":
      if(trim($data))
	$v2v['language'] .= $data;
      break;
    case "V2V:SUBLANGUAGE":
      if(trim($data))
	$v2v['sublanguage'] .= $data;
      break;
    case "DCTERMS:ALTERNATIVE":
      if(trim($data))
        $v2v['subtitle'] .= $data;
      break;
    case "DC:CREATOR":
      if(trim($data))
        $v2v['creator'] .= $data;
      break;
    case "V2V:VIDEOPAGE":
      if(trim($data))
        $v2v['videopage'] .= $data;
      break;
    case "DCTERMS:EXTENT":
      if(trim($data))
	$v2v['size'] .= $data;
      break;
    case "DCTERMS:TEMPORAL":
      if(trim($data))
	$v2v['duration'] .= $data;
      break;
			  
    case "DC:DATE":
      $date .= $data;
      break;
    case "DESCRIPTION":
      $v2v['description'] .= $data;
      break;
    }
  }
}

function output_rdf() {
  global $rdf_url,$timeToLive;
  $xml_parser = xml_parser_create();
  xml_set_element_handler($xml_parser, "startElement", "endElement");
  xml_set_character_data_handler($xml_parser, "characterData");
  
  $timeToLive *= 60;
  $rdf_local = "cache/" . basename($rdf_url);
  if (file_exists($rdf_local)) {
    $timestamp = filemtime($rdf_local);
    $age = (time() - $timestamp);
  }
  else {
    $age = 2* $timeToLive;
  }
  if($age > $timeToLive)
    {
      $rdfHandle = fopen($rdf_url,"r") ;
      do {
          $data = fread($rdfHandle, 8192);
	  if (strlen($data) == 0) {
	       break;
	  }
	$rdfData .= $data;
      } while(true);
      fclose($rdfHandle); // Close the Data feed
      $localFile = fopen($rdf_local, "w") ; // Open the local file for writing
      fwrite($localFile, $rdfData ) ;
      fclose($localFile) ;
    }
  $fp = fopen($rdf_local,"r")
    or die("Error reading RSS data.");
  while ($data = fread($fp, 64000))
    xml_parse($xml_parser, $data, feof($fp))
      or die(sprintf("XML error: %s at line %d", 
		     xml_error_string(xml_get_error_code($xml_parser)), 
		     xml_get_current_line_number($xml_parser)));
		     
  fclose($fp);
  xml_parser_free($xml_parser);
}
?>
