#!/usr/bin/perl
################################################################################
# "ml_create_statistic_graph.pl"                                               #
# This script create a picture with graphs of a statistic-logfile.             #
# After setup below you can use it like:                                       #
#                                                                              #
# perl ml_create_statistic_graph.pl>graph.png                                  #
################################################################################
# Copyright (C) 2003  Steffen Schirmer <steve@sixdots.de>                      #
# #ICQ: 132233699                                                              #
#                                                                              #
# This program is free software; you can redistribute it and/or                #
# modify it under the terms of the GNU General Public License                  #
# as published by the Free Software Foundation; either version 2               #
# of the License, or (at your option) any later version.                       #
#                                                                              #
# This program is distributed in the hope that it will be useful,              #
# but WITHOUT ANY WARRANTY; without even the implied warranty of               #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                #
# GNU General Public License for more details.                                 #
#                                                                              #
# You should have received a copy of the GNU General Public License            #
# along with this program; if not, write to the Free Software                  #
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.  #
################################################################################

use GD;

#Location of you statistic-logfile first argument:
$logfile=shift;

#Height of graph (not of picture). Should be higher or equal then 100 because of
#the memory and cpu efficiency graph.
$graph_height=300;

#Here you can set the zoomfacor of your up- and download-graph. You can zoom the
#x-axis and the y axis separately.
#Example: if your maximum downloadspeed can't grow heigher then 100 k/bs and your
#graph height is 300 then you can zoom the x-axis to the maximum with the
#factor 3.  (3*100 = 300 = $graph_height)
$zoomfactor_x=3;
$zoomfactor_y=3;

#Intervall of logfile-lines when the script puts a marking to the x-axis.
$font_interval_x=15;

#Intervall of downloadspeed when the script puts a marking to the y-axis.
$font_interval_y=5;

#Some visible settings:
$show_down       = 1; #show (1) or hide (0) the downstream graph
$show_up         = 1; #show (1) or hide (0) the upstream graph
$show_cpu        = 1; #show (1) or hide (0) the cpu graph
$show_mem        = 1; #show (1) or hide (0) the memory graph
$show_legend     = 1; #show (1) or hide (0) the legend
$show_timestamp  = 1; #show (1) or hide (0) the timestamp

#margin-width (free space) left, top, right and at the bottom of graph.
$border_left=30;
$border_top=20;
$border_right=30;
$border_bottom=30;

#Position of legend relative to left upper corner of picture.
$legende_posx=40;
$legende_posy=10;

#Position of timestap relative to left upper corner of picture.
$timestamp_posx=40;
$timestamp_posy=55;

################################################################################
################################################################################

#Read the logfile:
open (DAT,"<$logfile");
flock (DAT, 2);
@DATEI=<DAT>;
close (DAT);

#Get the count from the logfilearray:
$logcount=scalar(@DATEI);

#Create the new image:
$image = new GD::Image($border_right+$border_left+($logcount*$zoomfactor_x),$graph_height+$border_bottom+$border_top);

#Colors:
$color_transparent = $image->colorAllocate(255,255,255);
$color_down = $image->colorAllocate(0,0,0);
$color_up = $image->colorAllocate(0,0,255);
$color_cpu = $image->colorAllocate(0,170,0);
$color_mem = $image->colorAllocate(12,168,181);
$color_lines = $image->colorAllocate(255,0,0);
$color_timestamp = $image->colorAllocate(206,206,206);

#Make backgound transparent and "interlaced".
$image->transparent($white);
$image->interlaced('true');

$i=0;
$n=0;
foreach $eintraege (@DATEI){
   chomp($eintraege);
   ($datum,$zeit,$down,$up,$cpu,$mem)=split(/\;/,$eintraege);
   $down = sprintf "%d", $down;
   $up = sprintf "%d", $up;

   if ($show_down == 1){
       $image->line(($i-1)*$zoomfactor_x + $border_left , $border_top+$graph_height-($lastdown*$zoomfactor_y) , $i*$zoomfactor_x + $border_left, $border_top+$graph_height-($down*$zoomfactor_y),$color_down);}
   if ($show_up   == 1){
       $image->line(($i-1)*$zoomfactor_x + $border_left , $border_top+$graph_height-($lastup*$zoomfactor_y)   , $i*$zoomfactor_x + $border_left, $border_top+$graph_height-($up*$zoomfactor_y),$color_up);}
   if ($show_cpu  == 1){
       $image->line(($i-1)*$zoomfactor_x + $border_left , $border_top+$graph_height-($lastcpu*$zoomfactor_y)  , $i*$zoomfactor_x + $border_left, $border_top+$graph_height-($cpu*$zoomfactor_y),$color_cpu);}
   if ($show_mem  == 1){
       $image->line(($i-1)*$zoomfactor_x + $border_left , $border_top+$graph_height-($lastmem*$zoomfactor_y)  , $i*$zoomfactor_x + $border_left, $border_top+$graph_height-($mem*$zoomfactor_y),$color_mem);}

   if ($n==$font_interval_x)
      {   
      $image->line($i*$zoomfactor_x + $border_left , $border_top+$graph_height-2 , $i*$zoomfactor_x + $border_left, $border_top+$graph_height+2 , $color_lines);
      $image->string(gdSmallFont,($i*$zoomfactor_x)-13+$border_left,$border_top+$graph_height+2,"$zeit",$color_lines);
      $n=0;
      }

   $lastdown=$down;
   $lastup=$up;
   $lastcpu=$cpu;
   $lastmem=$mem;
   $i++;
   $n++;
}

# Linie unter den Graphen:
$image->line(0,$graph_height+$border_top,($zoomfactor_x)*$logcount+$border_left+$border_right,$graph_height+$border_top,$color_lines);
# Linie links:
$image->line($border_left,  0,  $border_left,  $graph_height+$border_top+$border_bottom,  $color_lines);
# Linie rechts:
$image->line($border_left+($logcount*$zoomfactor_x),  0,$border_left+($logcount*$zoomfactor_x),$graph_height+$border_top+$border_bottom,$color_lines);

for(my $m = $font_interval_y; $m <= (($graph_height/$zoomfactor_y)-$font_interval_y); $m=$m+$font_interval_y)
   {
   $image->line($border_left+($logcount*$zoomfactor_x)-2,   $border_top+$graph_height-($m*$zoomfactor_y),   $border_left+($logcount*$zoomfactor_x)+2,   $border_top+$graph_height-($m*$zoomfactor_y),$color_lines);
   $image->string(gdSmallFont,   $border_left+($logcount*$zoomfactor_x)+5,   $border_top+$graph_height-($m*$zoomfactor_y)-6,   "$m",   $color_lines);

   $image->line($border_left-2,   $border_top+$graph_height-($m*$zoomfactor_y),   $border_left+2,   $border_top+$graph_height-($m*$zoomfactor_y),   $color_lines);
   $image->string(gdSmallFont,   $border_left-15,   $border_top+$graph_height-($m*$zoomfactor_y)-6,   "$m",   $color_lines);
   }

if ($show_timestamp == 1)
   {
   $image->string(gdSmallFont,$timestamp_posx,$timestamp_posy,"[$datum / $zeit]",$color_timestamp);
   }

if ($show_legend == 1)
   {
   $image->filledRectangle(0+$legende_posx,  00+$legende_posy,  8+$legende_posx,  00+8+$legende_posy,  $color_down);
   $image->filledRectangle(0+$legende_posx,  11+$legende_posy,  8+$legende_posx,  11+8+$legende_posy,  $color_up);
   $image->filledRectangle(0+$legende_posx,  22+$legende_posy,  8+$legende_posx,  22+8+$legende_posy,  $color_cpu);
   $image->filledRectangle(0+$legende_posx,  33+$legende_posy,  8+$legende_posx,  33+8+$legende_posy,  $color_mem);

   $image->string(gdSmallFont, 11+$legende_posx,  00+$legende_posy-3,  "Downstream kb/s",  $color_down);
   $image->string(gdSmallFont, 11+$legende_posx,  11+$legende_posy-3,  "Upstream kb/s",  $color_up);
   $image->string(gdSmallFont, 11+$legende_posx,  22+$legende_posy-3,  "CPU %",  $color_cpu);
   $image->string(gdSmallFont, 11+$legende_posx,  33+$legende_posy-3,  "Mem %",  $color_mem);
   }

# Einen Binr-Stream sicherstellen.
binmode STDOUT;

# Image nach PNG umwandeln und ber die Standardausgabe ausgeben.
print $image->png;
